﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "uart.h"

unsigned char uart_trans_ok = 1;
unsigned char uart_receive_ok = 0;
unsigned char uart_trans_1byte_ok = 0;
unsigned char uart_trans_data[8] = {0x12,0xC5,0x73,0x5F,0xA5,0xAB,0x29,0xD9};
unsigned char uart_receive_data[8] = {0};
unsigned char i = 0;
unsigned char j = 0;
//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(UR0IF)
	{
		if(UR0_TEIF && UR0_TEIE)		//发送中断表示发送FIFO数据已取走为空，可向其写入数据，但串口仍处于发送数据状态，需判断TX_BUSY为0方可进入休眠
		{
			UR0_TEIF = 0;
			uart_trans_1byte_ok = 1;
			j++;
		}
		else if(UR0_RNIF && UR0_RNIE)	//接收FIFO非空中断
		{
			uart_receive_data[i] = UR0_RX_REG;
			i++;
		}
		else if(UR0_RHIF && UR0_RHIE)	//接收FIFO半满中断，共有8级接收FIFO，数据长度大于等于4时中断标志位置起
		{
			if(i >= 4)
			{
				for(i=4;i<8;i++)
				{
					uart_receive_data[i] = UR0_RX_REG;
				}
			}
			else
			{
				for(i=0;i<4;i++)
				{
					uart_receive_data[i] = UR0_RX_REG;
				}
			}
		}
		else if(UR0WK_IF && UR0WK_IE)	//串口接收唤醒中断，唤醒后建议查询RX_BUSY位，若为0则唤醒可能是由于干扰造成
		{
			UR0WK_IF = 0;
		}
		else if(UR0ERRIF && UR0ERRIE)	//接收错误标志位，不可直接清零，在查询并清除RX_OV_ERR、STOP_ERR标志位后自动清零
		{
			if(RX_OV_ERR)
			{
				RX_OV_ERR = 0;
			}
			if(STOP_ERR)
			{
				STOP_ERR = 0;
			}
		}
	}
}

//============================================
// program start
//============================================
void main()
{
 	unsigned char mode = 0;
	uart_init();		//波特率为38400，PT5.2为RX，PT5.3为TX
	while(1)
	{
		switch(mode)
		{
			case 0 :			//使能接收FIFO非空中断，在接收到8字节数据后会自动回复8字节数据
			{
				if(uart_trans_ok)
				{
					uart_receive_ok = 0;
					UR0_INTE = 0x15;
					if(i >= 8)
					{
						i = 0;
						j = 0;
						uart_receive_ok = 1;
						UR0_TX_REG = uart_trans_data[j];
					}
				}
			}break;
			
			case 1 :			//使能接收FIFO半满中断，在接收到8字节数据后会自动回复8字节数据
			{
				if(uart_trans_ok)
				{
					uart_receive_ok = 0;
					UR0_INTE = 0x19;
					if(i >= 8)
					{
						i = 0;
						j = 0;
						uart_receive_ok = 1;
						UR0_TX_REG = uart_trans_data[j];
					}
				}
			}break;
			
			default : mode = 0;
		}
		if(uart_receive_ok)			//判断是否接收到8字节数据
		{
			uart_trans_ok = 0;
			if(uart_trans_1byte_ok)
			{
				uart_trans_1byte_ok = 0;
				if(j >= 8)
				{
					j = 0;
					uart_trans_ok = 1;
				}
				else
				{
					UR0_TX_REG = uart_trans_data[j];
				}
			}
		}
	}
}